﻿/*Close questions panel*/
$(document).on("click", ".hideQuestionPanel", function (e) {
    if ($(".configuration").hasClass("showQuestionPanel")) {
        $(".configuration").removeClass("showQuestionPanel");
        $(".configuration").addClass("hideCollapsePanel");
        $(".dashboard").css("width", "100%");
        $(".nps-dashboard").css("width", "100%");
        $(".text-highlighter-dashboard").css("width", "100%");
        $(".configuration").animate({}, "slow");
    }

    var npsScoreAdditionalLegend = $("#additionalLegend");
    if (npsScoreAdditionalLegend) {
        if (npsScoreAdditionalLegend.hasClass("additionalLegend-partialScreen")) {
            npsScoreAdditionalLegend.removeClass("additionalLegend-partialScreen");
            npsScoreAdditionalLegend.addClass("additionalLegend-partialScreen-hideQuestionPanel");
        } else if (npsScoreAdditionalLegend.hasClass("additionalLegend-fullScreen")) {
            npsScoreAdditionalLegend.removeClass("additionalLegend-fullScreen");
            npsScoreAdditionalLegend.addClass("additionalLegend-fullScreen-hideQuestionPanel");
        }
    }
});

/*Open questions panel*/
$(document).on("click", ".clipbordIconDiv", function (e) {
    if ($(".configuration").hasClass("hideCollapsePanel")) {
        $(".configuration").removeClass("hideCollapsePanel");
        $(".filter-configuration").removeClass("showQuestionPanel");
        $(".configuration").addClass("showQuestionPanel");
        $(".filter-configuration").addClass("hideCollapsePanel");
        $(".dashboard").css("width", "85%");
        $(".nps-dashboard").css("width", "85%");
        $(".text-highlighter-dashboard").css("width", "85%");
        $(".configuration").animate({}, "slow");
    }

    var npsScoreAdditionalLegend = $("#additionalLegend");
    if (npsScoreAdditionalLegend) {
        if (npsScoreAdditionalLegend.hasClass("additionalLegend-partialScreen-hideQuestionPanel")) {
            npsScoreAdditionalLegend.removeClass("additionalLegend-partialScreen-hideQuestionPanel");
            npsScoreAdditionalLegend.addClass("additionalLegend-partialScreen");
        } else if (npsScoreAdditionalLegend.hasClass("additionalLegend-fullScreen-hideQuestionPanel")) {
            npsScoreAdditionalLegend.removeClass("additionalLegend-fullScreen-hideQuestionPanel");
            npsScoreAdditionalLegend.addClass("additionalLegend-fullScreen");
        }
    }
});

/*Open filter panel*/
$(document).on("click", ".filterIconDiv", function (e) {
    if ($(".filter-configuration").hasClass("hideCollapsePanel")) {
        $(".configuration").removeClass("showQuestionPanel");
        $(".configuration").addClass("hideCollapsePanel");
        $(".filter-configuration").removeClass("hideCollapsePanel");
        $(".filter-configuration").addClass("showFilterPanel");
        $(".dashboard").css("width", "85%");
        $(".nps-dashboard").css("width", "78%");
        $(".text-highlighter-dashboard").css("width", "85%");
        $(".filter-configuration").animate({}, "slow");
    }
});

/*Close filter panel*/
$(document).on("click", ".closeFilterPanel", function (e) {
    if ($(".filter-configuration").hasClass("showFilterPanel")) {
        $(".configuration").removeClass("showQuestionPanel");
        $(".configuration").addClass("hideCollapsePanel");
        $(".filter-configuration").removeClass("showFilterPanel");
        $(".filter-configuration").addClass("hideCollapsePanel");
        $(".dashboard").css("width", "100%");
        $(".nps-dashboard").css("width", "100%");
        $(".text-highlighter-dashboard").css("width", "100%");
        $(".filter-configuration").animate({}, "slow");
    }
});

function convertDates(date, keepTime) {
    if (date !== null) {
        var userLanguage = $("#userLanguage").val();
        if (date.includes('/')) { var splittedDate = date.split("/"); }
        if (date.includes('-')) { var splittedDate = date.split("-"); }
        if (splittedDate[0].length < 2) {
            splittedDate[0] = "0" + splittedDate[0];
        } else {
            splittedDate[0] = splittedDate[0];
        }
        if (splittedDate[1].length < 2) {
            splittedDate[1] = "0" + splittedDate[1];
        } else {
            splittedDate[1] = splittedDate[1];
        }

        var splited = splittedDate[2].split(' ');
        var timePart = '';
        
        if (keepTime && splited.length > 1) {
            timePart = splited.slice(1).join(' ');
        }

        if (userLanguage == 'fr') {
            return newDate = splited[0] + "-" + splittedDate[1] + "-" + splittedDate[0] + (keepTime ? ' ' + timePart : '');
        } else {
            return newDate = splited[0] + "-" + splittedDate[0] + "-" + splittedDate[1] + (keepTime ? ' ' + timePart : '');
        }
    }
}

function showLoadingAnimation() {
    $("#initialInstructions").hide();
    showLoader(resources.LoadDashboard);
}

function showLoader(loadingText) {
    var loader = $("#loaderIcon");
    if (loadingText && loadingText != "") {
        $(".loading-text-content #loadingStatus", loader).text(loadingText);
    }
    loader.removeClass("hide");
}

function hideLoader() {
    $("#loaderIcon").addClass("hide");
    $("#onDemandUpdate .h-newModuleMenu").addClass("dropdown-container");
}

function activitySectionValidation(filterAnalytics, responsesFilter) {
    var fromDate = $('.filter-fromDate').val();
    var toDate = $('.filter-toDate').val();
    var hasValidActivitySection = $('.v-optionLastActivityType input:radio:checked').length > 0 || (fromDate !== '' && toDate !== '');

    if (filterAnalytics.FilterSettings.SentimentType === 'All' && !hasValidActivitySection && (responsesFilter && responsesFilter.Conditions.length < 1)) {
        if (fromDate !== '' && toDate !== '') {
            a4.showErrorMessage(filterMessage.FilterDateSelectionAlert);
        }
        else {
            a4.showErrorMessage(filterErrorsResources.NoFilterConfigurationChosen);
        }
        return false;
    }
    else if (!hasValidActivitySection) {
        a4.showErrorMessage(filterMessage.FilterDateSelectionAlert);
        return false;
    }
    else {
        return true;
    }
}

function bindFilterSettings(context, filterData) {
    setLastActivitySectionFieldValues(context, filterData);
}

function setLastActivitySectionFieldValues(context, filterData) {
    dashboardFilter.resetLastActivitySection(context);// reset last activity values

    if (filterData && filterData.FilterSettings) {
        if (filterData.FilterSettings.IsSelectionToday == true) {
            $('.v-optionLastActivityType #filterDateToday').prop('checked', true)
        }
        else if (filterData.FilterSettings.IsSelectionThisMonth == true) {
            $('.v-optionLastActivityType #filterDateThisMonth').prop('checked', true)
        }
        else {
            //From and ToDate needs to set in filterAnalytics object before calling this method as filterAnalytics data values might be different than actual
            if (filterAnalytics.FromDate) { $('.filter-fromDate').val(convertDates(filterAnalytics.FromDate, true)) }
            if (filterAnalytics.ToDate) { $('.filter-toDate').val(convertDates(filterAnalytics.ToDate, true)) }
        }
    }
}

// last activity toggle functionality
$('.toggleLastActivity').on("click", function () {
    $(".last-activity-section").toggle();
    $('.toggleLastActivity').toggleClass("fa-caret-down fa-caret-right");
});